﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using Ext.Net;
using System.Data;
using DataAccess;
using System.Text;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "REPSSTAT")]

public partial class reports_stat : System.Web.UI.Page
{
    /// <summary>
    /// Initialize controls in the page
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Init(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            LoadStaticData();
        }
    }

    /// <summary>
    /// page load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            //this page closes the patient
            Master.ClosePatient();

            tfRequestName.Focus();

            btnCancelRequest.Enabled = false;
            btnDownloadCSV.Enabled = false;


        }

    }

    /// <summary>
    /// Load static data to populate dropdowns and other controls for the user to select values
    /// </summary>
    protected void LoadStaticData()
    {
        CStat stat = new CStat(Master);

        CRegionSite region = null;
        CCPA cpa = null;
        CDataConverter cdc = null;
        CReportsStat rep = null;
        string strJSON = String.Empty;

        if (!X.IsAjaxRequest)
        {
            cdc = new CDataConverter();

            //get the region dataset
            region = new CRegionSite(Master);
            DataSet dsRegion = region.GetRegionsDS();
            strJSON = cdc.GetJsonDSString(dsRegion);
            storeFilterRegion.SetDataFromJson(strJSON);

            //load tree
            BuildDataFieldTree(true, String.Empty);

            //load MyRequest
            LoadMyRequestList();

        }
    }

    /// <summary>
    /// Load request grid
    /// </summary>
    private void LoadMyRequestList()
    {
        CReportsStat rep = new CReportsStat(Master);
        CDataConverter cdc = new CDataConverter();

        DataSet dsMyRequest = rep.GetMyRequestDS();
        string strJSON = cdc.GetJsonDSString(dsMyRequest);

        storeMyRequest.SetDataFromJson(strJSON);
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public void ClearSiteSel()
    {
        //cboFilterSite.SelectedItems.Clear();
        //cboFilterSite.UpdateSelectedItems();
    }

    /// <summary>
    /// Load Site list corresponding to the specify Region
    /// </summary>
    /// <param name="lRegionID"></param>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public void LoadSite(long lRegionID)
    {
        //remove all items from the store
       // cboFilterSite.GetStore().RemoveAll();
        
        //update the content area of the combo
        //cboFilterSite.Update();

        //get site dataset matching region id
        CRegionSite region = new CRegionSite(Master);
        DataSet dsSite = region.GetSiteDS(lRegionID);

        //load site store
        CDataConverter cdc = new CDataConverter();
        string strJSON = cdc.GetJsonDSString(dsSite);
        storeFilterSite.SetDataFromJson(strJSON);
        
       // cboFilterProgram.UpdateSelectedItems();
//        cboFilterSite.UpdateSelectedItems();

        //update the content area of the combo
        //cboFilterSite.Update();

        //clear the program filter s    election
        //cboFilterProgram.SelectedItems.Clear();
        //cboFilterProgram.UpdateSelectedItems();
       
        //clear the currently selected item in the site combo
        //cboFilterSite.SelectedItems.Clear();
        //cboFilterSite.UpdateSelectedItems();

        /*Ext.Net.ListItem li = new Ext.Net.ListItem();
        li.Value = "-1";
        li.Mode = ParameterMode.Raw;
        cboFilterSite.Items.Add(li);
        cboFilterSite.SelectedItems.Add(li);
        cboFilterSite.UpdateSelectedItems();*/


        //clear site combo in prep for load below
        
        //cboFilterSite.Items.Clear();
        //cboFilterSite.GetStore().RemoveAll();
        //storeFilterSite.SetDataFromJson(CDataUtils2.GetEmptyJSON());
        //cboFilterSite.UpdateSelectedItems();

        
        //clear program
        //cboFilterProgram.GetStore().RemoveAll();
        //cboFilterProgram.SelectedItems.Clear();
        //cboFilterProgram.Items.Clear();
       
        //cboFilterSite.Update();
        //cboFilterProgram.Update();

        //cboFilterSite.Clear();
        //cboFilterProgram.Clear();
                
    }

    /// <summary>
    /// Load Program list corresponding to the specify Region - Site
    /// </summary>
    /// <param name="lSiteID"></param>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public void LoadProgram(long lSiteID)
    {
        if (cboFilterRegion.SelectedItem != null)
        {
            long lRegionID = Convert.ToInt64(cboFilterRegion.SelectedItem.Value);

            //get programs...
            CCPA cpa = new CCPA();
            DataSet dsCPA = cpa.GetCPADS(Master, lRegionID, lSiteID);
            DataSet dsView = new DataSet();

            dsView = dsCPA.Clone();

            for (int i = 0; i < dsCPA.Tables[0].Rows.Count; i++)
            {
                if (dsCPA.Tables[0].Rows[i].ItemArray[1].ToString() != "Open Pathway")
                {
                    dsView.Tables[0].ImportRow(dsCPA.Tables[0].Rows[i]);
                }
            }

            CDataConverter cdc = new CDataConverter();
            string strJSON = cdc.GetJsonDSString(dsView);
            cboFilterProgram.Clear();
            storeFilterProgram.SetDataFromJson(strJSON);

            cboFilterProgram.SelectedItems.Clear();
            cboFilterProgram.UpdateSelectedItems();
            cboFilterProgram.UpdateLayout();
        }
        
    }

    /// <summary>
    /// US: 7986, 7984, 7988, 7989. Build the DataField selection tree
    /// </summary>
    /// <param name="bInit"></param>
    /// <param name="strDataSelected"></param>
    private void BuildDataFieldTree(bool bInit,
                                    string strDataSelected)
    {
        Ext.Net.Node nRoot = new Node() { Expanded = true, EmptyChildren = true };
        Ext.Net.Node nGroup = null;
        Ext.Net.Node nItem = null;

        //Demographics
        nGroup = new Ext.Net.Node()
        {
            Text = "Demographics",
            Icon = Icon.Folder,
            Expanded = false,
            Checked = false
        };

        nItem = new Ext.Net.Node()
        {
            Text = "City",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "CITY"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem{ 
                    Name = "field", 
                    Value = "CITY", 
                    Mode = Ext.Net.ParameterMode.Auto }}
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "State",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "STATE"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem{ 
                    Name = "field", 
                    Value = "STATE", 
                    Mode = Ext.Net.ParameterMode.Auto }}
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Postal Code",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "POSTAL_CODE"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "POSTAL_CODE", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "DOB",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "DOB"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "DOB", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Gender",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "GENDER"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "GENDER", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Duty Status",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "DUTY_STATUS"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "DUTY_STATUS", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Preferred Language",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "PREFERRED_LANGUAGE"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "PREFERRED_LANGUAGE", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Ethnicity",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "ETHNICITY"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "ETHNICITY", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Race",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "RACE"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "RACE", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Hand Preference",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "HAND_PREFERENCE"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "HAND_PREFERENCE", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);

        nRoot.Children.Add(nGroup);


        //Socioeconomics
        nGroup = new Ext.Net.Node()
        {
            Text = "Socioeconomics",
            Icon = Icon.Folder,
            Expanded = false,
            Checked = false
        };

        nItem = new Ext.Net.Node()
        {
            Text = "Highest Grade Level",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "HIGHEST_GRADE_LEVEL"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "HIGHEST_GRADE_LEVEL",
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Highest Degree Obtained",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "HIGHEST_DEGREE_OBTAINED"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field",
                    Value = "HIGHEST_DEGREE_OBTAINED",
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Marital Status",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "MARITAL_STATUS"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "MARITAL_STATUS", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Employment Status",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "EMPLOYMENT_STATUS"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "EMPLOYMENT_STATUS", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Job Classification Category",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "JOB_CLASS_CAT"),
            CustomAttributes = {
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "JOB_CLASS_CAT", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);

        nRoot.Children.Add(nGroup);


        //Past Medical History
        nGroup = new Ext.Net.Node()
        {
            Text = "Past Medical History",
            Icon = Icon.Folder,
            Expanded = false,
            Checked = false
        };

        nItem = new Ext.Net.Node()
        {
            Text = "Primary impairment",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "PRIMARY_IMP"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "PRIMARY_IMP", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Primary impairment onset date",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "PRIMARY_IMP_DATE"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "PRIMARY_IMP_DATE", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Mechanism of injury",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "MCH_INJURY"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "MCH_INJURY", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);
        nItem = new Ext.Net.Node()
        {
            Text = "Comorbidity",
            Leaf = true,
            Checked = IsDataFieldSelected(strDataSelected, "COMORBIDITY"),
            CustomAttributes = { 
                new Ext.Net.ConfigItem { 
                    Name = "field", 
                    Value = "COMORBIDITY", 
                    Mode = Ext.Net.ParameterMode.Auto } }
        };
        nGroup.Children.Add(nItem);

        nRoot.Children.Add(nGroup);


        //all the modules
        nGroup = new Ext.Net.Node()
        {
            Text = "Instruments",
            Icon = Icon.Folder,
            Expanded = false,
            Checked = false
        };

        CCPA cpa = new CCPA();
        DataSet dsMID = cpa.GetAllModuleDS(Master);

        foreach (DataTable table in dsMID.Tables)
        {
            foreach (DataRow row in table.Rows)
            {
                nItem = new Ext.Net.Node()
                {
                    Text = row["MODULE"].ToString(),
                    Leaf = true,
                    Checked = IsDataFieldSelected(strDataSelected, row["MID"].ToString()),
                    CustomAttributes = { 
                        new Ext.Net.ConfigItem { 
                            Name = "field", 
                            Value = row["MID"].ToString(), 
                            Mode = Ext.Net.ParameterMode.Auto } }
                };
                nGroup.Children.Add(nItem);
            }
        }
        nRoot.Children.Add(nGroup);


        //render the tree...
        if (bInit == true)
        {
            tDataFields.Root.Add(nRoot);
        }
        else
        {
            tDataFields.SetRootNode(nRoot);
        }
    }

    /// <summary>
    /// Check if the DataField is part of the data fields that were selected for a "export request".
    /// </summary>
    /// <param name="strDataSelection"></param>
    /// <param name="strDataField"></param>
    /// <returns></returns>
    private bool IsDataFieldSelected(string strDataSelection,
                                     string strDataField)
    {
        if (!String.IsNullOrEmpty(strDataSelection))
        {
            if (strDataSelection.IndexOf(strDataField) > -1)
            {
                return true;
            }
        }

        return false;
    }

    /// <summary>
    /// US: 8064. Create new "export request".
    /// </summary>
    /// <returns></returns>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public long OnCreateExportRequest()
    {
        CReportsStat rep = null;
        DataSet dsNewRequest = null;
        long lRequestID = -1;

        //validate name
        string strNewRequestName = txtExportRequestName.Text.Trim();
        if (String.IsNullOrEmpty(strNewRequestName))
        {
            Master.ShowSystemFeedback("Please enter a valid name!", "Error");
            return -1;
        }

        //Create export request...
        rep = new CReportsStat(Master);
        dsNewRequest = rep.CreateExportRequestDS(strNewRequestName);
        if (dsNewRequest == null)
        {
            if (Master.StatusCode == 1)
            {
                Master.ShowSystemFeedback("Unable to create new export request.", "Error");
            }
            if (Master.StatusCode == 2)
            {
                Master.ShowSystemFeedback("There is already a request with this name. Please enter a new export request name.", "Error");
            }

            return -1;
        }

        //get the RequestID
        foreach (DataTable dt in dsNewRequest.Tables)
        {
            foreach (DataRow dr in dt.Rows)
            {
                if (!dr.IsNull("REQUEST_ID"))
                {
                    lRequestID = Convert.ToInt64(dr["REQUEST_ID"].ToString());
                }
                else
                {
                    lRequestID = -1;
                }
            }
        }

        //reload MyRequest list...
        LoadMyRequestList();

        Master.ShowSystemFeedback("New export request created!", "New Export Request");
        winExportRequest.Hide();

        return lRequestID;

    }

    /// <summary>
    /// US: 8065. Rename export request.
    /// </summary>
    /// <param name="lRequestID"></param>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public void OnRenameExportRequest(long lRequestID)
    {
        CReportsStat rep = null;
        bool bStatus = false;
        string strNewExportRequestName = txtExportRequestName.Text.Trim();

        //validate name
        if (String.IsNullOrEmpty(strNewExportRequestName))
        {
            Master.ShowSystemFeedback("Please enter a valid name!", "Error");
            return;
        }

        //Rename...
        rep = new CReportsStat(Master);
        bStatus = rep.RenameExportRequest(lRequestID, strNewExportRequestName);
        if (!bStatus)
        {
            if (Master.StatusCode == 1)
            {
                Master.ShowSystemFeedback("Unable to rename the export request.", "Error");
            }
            if (Master.StatusCode == 2)
            {
                Master.ShowSystemFeedback("There is already a request with this name. Please enter a different export request name.", "Error");
            }
            if (Master.StatusCode == 3)
            {
                Master.ShowSystemFeedback("Request ID " + lRequestID.ToString() + " not found.", "Error");
            }

            return;
        }

        //reload MyRequest
        LoadMyRequestList();

        //show successful msg
        Master.ShowSystemFeedback("Rename successful!", "Rename Export Request");
        winExportRequest.Hide();

    }

    /// <summary>
    /// US: 7991. Update Filters and DataFields for a request with status 0 (New)
    /// </summary>
    /// <param name="lRequestID"></param>
    /// <param name="strDataFields"></param>
    /// <param name="bShowMsg"></param>
    /// <returns></returns>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public bool OnUpdateExportRequest(long lRequestID,
                                      string strDataFields,
                                      bool bShowMsg)
    {
        //Update export request...
        CReportsStat rep = null;
        bool bStatus = false;
        string strFilters = String.Empty;

        //validate
        bStatus = ValidateFiltersAndDataFields(strDataFields);
        if (!bStatus)
        {
            return false;
        }

        //filters...
        strFilters = GetFilterString();

        //update...
        rep = new CReportsStat(Master);
        bStatus = rep.UpdateExportRequest(lRequestID, strFilters, strDataFields);
        if (!bStatus)
        {
            if (Master.StatusCode != 0)
            {
                if (bShowMsg)
                {
                    Master.ShowSystemFeedback("Unable to save changes.", "Error");
                }
            }

            return false;
        }

        //show successful msg
        if (bShowMsg)
        {
            Master.ShowSystemFeedback("Save successful!", "Save Export Request");
        }

        return true;

    }

    /// <summary>
    /// Load specific export quest.
    /// </summary>
    /// <param name="lRequestID"></param>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public void OnLoadExportRequest(long lRequestID)
    {
        CReportsStat rep = null;
        DataSet dsExportRequest = null;
        string strReportName = String.Empty;
        string strFilters = String.Empty;
        string strDataSelected = String.Empty;

        //load...
        rep = new CReportsStat(Master);
        dsExportRequest = rep.GetExportRequestDS(lRequestID);
        if (dsExportRequest == null)
        {
            if (Master.StatusCode == 1)
            {
                Master.ShowSystemFeedback("Unable to load information of the selected export request.", "Error");
            }
            if (Master.StatusCode == 2)
            {
                Master.ShowSystemFeedback("Export request not found.", "Error");
            }

            return;
        }

        //get the data from the DataSet
        foreach (DataTable dt in dsExportRequest.Tables)
        {
            foreach (DataRow dr in dt.Rows)
            {
                if (!dr.IsNull("REPORT_NAME"))
                {
                    strReportName = dr["REPORT_NAME"].ToString();
                }
                if (!dr.IsNull("FILTERS"))
                {
                    strFilters = dr["FILTERS"].ToString();
                }
                if (!dr.IsNull("DATA_INCLUDED"))
                {
                    strDataSelected = dr["DATA_INCLUDED"].ToString();
                }
            }
        }

        //Report Name
        tfRequestName.Text = strReportName;

        //load request filters...
        LoadFilterControls(strFilters);
        
        //load request data field selection...
        BuildDataFieldTree(false, strDataSelected);

    }

    /// <summary>
    /// Set values to the controls of the filter area.
    /// </summary>
    /// <param name="strFilters"></param>
    private void LoadFilterControls(string strFilters)
    {
        ClearFilterSelection();

        string[] strFilterItems = strFilters.Split(',');
        string strDT = String.Empty;
        string strRegionVal = String.Empty;
        string strSiteVal = String.Empty;
        Ext.Net.ListItem itm = null;

        foreach (string strFilter in strFilterItems)
        {
            string[] strFltrStruc = strFilter.Split('=');
            itm = new Ext.Net.ListItem();

            switch (strFltrStruc[0])
            {
                case "start_date":
                    strDT = String.Empty;
                    strDT = strFltrStruc[1].Trim('\'');
                    dfFromDate.SetRawValue(strDT.Substring(4, 2) + "/" + strDT.Substring(6, 2) + "/" + strDT.Substring(0, 4));
                    break;

                case "end_date":
                    strDT = String.Empty;
                    strDT = strFltrStruc[1].Trim('\'');
                    dfToDate.SetRawValue(strDT.Substring(4, 2) + "/" + strDT.Substring(6, 2) + "/" + strDT.Substring(0, 4));
                    break;

                case "region":
                    strRegionVal = strFltrStruc[1];

                    itm.Value = strFltrStruc[1];
                    itm.Mode = ParameterMode.Raw;
                    cboFilterRegion.SelectedItems.Add(itm);
                    cboFilterRegion.UpdateSelectedItems();
                    break;

                case "site":
                    LoadSite(Convert.ToInt64(strRegionVal));

                    strSiteVal = strFltrStruc[1];

                    itm.Value = strFltrStruc[1];
                    itm.Mode = ParameterMode.Raw;
                    cboFilterSite.SelectedItems.Add(itm);
                    cboFilterSite.UpdateSelectedItems();
                    break;

                case "program":
                    LoadProgram(Convert.ToInt64(strSiteVal));

                    itm.Value = strFltrStruc[1];
                    itm.Mode = ParameterMode.Raw;
                    cboFilterProgram.SelectedItems.Add(itm);
                    cboFilterProgram.UpdateSelectedItems();
                    break;

                case "inpatient":
                    chkInpatient.Checked = strFltrStruc[1] == "1";
                    break;

                case "outpatient":
                    chkOutpatient.Checked = strFltrStruc[1] == "1";
                    break;

            }
        }
    }

    /// <summary>
    /// Clear filter area
    /// </summary>
    private void ClearFilterSelection()
    {
        dfFromDate.Clear();
        dfToDate.Clear();

        cboFilterRegion.SelectedItems.Clear();
        cboFilterRegion.UpdateSelectedItems();

        cboFilterSite.SelectedItems.Clear();
        cboFilterSite.UpdateSelectedItems();

        cboFilterProgram.SelectedItems.Clear();
        cboFilterProgram.UpdateSelectedItems();

        chkInpatient.Checked = false;
        chkOutpatient.Checked = false;
    }




    /// <summary>
    /// US: 8080. Save current "export request" selected as a new "export request".
    /// </summary>
    /// <param name="strDataFields"></param>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public void OnSaveAsExportRequest(string strDataFields)
    {
        //Save As...
        CReportsStat rep = null;
        bool bStatus = false;
        string strFilters = String.Empty;

        //validate name
        string strNewRequestName = txtExportRequestName.Text.Trim();
        if (String.IsNullOrEmpty(strNewRequestName))
        {
            Master.ShowSystemFeedback("Please enter a valid name!", "Error");
            return;
        }

        //filters...
        DateTime dtFrom = dfFromDate.SelectedDate;
        DateTime dtTo = dfToDate.SelectedDate;
        strFilters = "start_date='" + dtFrom.ToString("yyyyMMdd") + "',";
        strFilters += "end_date='" + dtTo.ToString("yyyyMMdd") + "',";
        strFilters += "region=" + cboFilterRegion.SelectedItem.Value + ",";
        strFilters += "site=" + cboFilterSite.SelectedItem.Value + ",";
        strFilters += "program=" + cboFilterProgram.SelectedItem.Value + ",";
        strFilters += "inpatient=" + (chkInpatient.Checked ? 1 : 0) + ",";
        strFilters += "outpatient=" + (chkOutpatient.Checked ? 1 : 0);


        //Create export request...
        rep = new CReportsStat(Master);
        bStatus = rep.SaveAsExportRequest(strNewRequestName, strFilters, strDataFields);
        if (!bStatus)
        {
            if (Master.StatusCode == 1)
            {
                Master.ShowSystemFeedback("Unable to save export request.", "Error");
            }
            if (Master.StatusCode == 2)
            {
                Master.ShowSystemFeedback("There is already a request with this name. Please enter a new export request name.", "Error");
            }

            return;
        }

        //reload MyRequest list...
        LoadMyRequestList();

        Master.ShowSystemFeedback("Successful!", "Save As");
        winExportRequest.Hide();

    }

    /// <summary>
    /// US: 7990. Submit "export request" to CSV file builder process.
    /// </summary>
    /// <param name="lRequestID"></param>
    /// <param name="strDataFields"></param>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public void OnSubmitExportRequest(long lRequestID,
                                      string strDataFields)
    {
        //Submit export request...
        CReportsStat rep = null;
        bool bStatus = false;
        string strFilters = String.Empty;

        //validate
        bStatus = ValidateFiltersAndDataFields(strDataFields);
        if (!bStatus)
        {
            return;
        }

        //filters...
        strFilters = GetFilterString();

        //submit...
        rep = new CReportsStat(Master);
        bStatus = rep.SubmitExportRequest(lRequestID, strFilters, strDataFields);
        if (!bStatus)
        {
            if (Master.StatusCode != 0)
            {
                Master.ShowSystemFeedback("Unable to submit export request.", "Error");
            }

            return;
        }

        //refresh MyReqeuest list
        LoadMyRequestList();

        //show successful msg
        Master.ShowSystemFeedback("Submit successful! Please check in 24hrs.", "Submit Export Request");

    }


    /// <summary>
    /// 
    /// Submit new request.
    /// </summary>
    /// <param name="strDataFields"></param>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public object OnSubmitNewExportRequest(string strDataFields)
    {
        //Submit new export request...
        CReportsStat rep = null;
        bool bStatus = false;
        string strFilters = String.Empty;
        string strErrTitle = String.Empty;
        string strErrMsg = String.Empty;

        //validate
        bStatus = ValidateFiltersAndDataFields(strDataFields);
        if (!bStatus)
        {
            return new { submitted = false, errTitle = "", errMsg = "" };
        }

        //filters...
        strFilters = GetFilterString();

        //submit...
        rep = new CReportsStat(Master);
        bStatus = rep.SubmitNewExportRequest(tfRequestName.Text.Trim(), strFilters, strDataFields);
        if (!bStatus)
        {
            if (Master.StatusCode == 1)
            {
                strErrTitle = "Error";
                strErrMsg = "Unable to submit export request.";
            }
            if (Master.StatusCode == 2)
            {
                strErrTitle = "Error";
                strErrMsg = "There is already a request with this name. Please enter a new export request name.";
            }

            return new { submitted = false, errTitle = strErrTitle, errMsg = strErrMsg };
        }

        //refresh MyReqeuest list
        LoadMyRequestList();

        //show successful msg
        Master.ShowSystemFeedback("Submit successful! Please check in 24hrs.", "Submit Export Request");

        return new { submitted = true, errTitle = "", errMsg = "" };

    }

    /// <summary>
    /// Validate Filters and DataFields selection.
    /// </summary>
    /// <param name="strDataFields"></param>
    /// <returns></returns>
    private bool ValidateFiltersAndDataFields(string strDataFields)
    {
        bool bStatus = true;

        //validate name...
        if (String.IsNullOrEmpty(tfRequestName.Text))
        {
            Master.ShowSystemFeedback("Please enter a name for this request.", "Error");
            bStatus = false;
            return bStatus;
        }

        //validate
        DateTime dtFrom = dfFromDate.SelectedDate;
        DateTime dtTo = dfToDate.SelectedDate;
        if (dtFrom.Year == 1 ||
           dtTo.Year == 1 ||
           (dtFrom > dtTo))
        {
            Master.ShowSystemFeedback("Please select a valid 'From' and 'To' date.", "Error");
            bStatus = false;
            return bStatus;
        }
        if (String.IsNullOrEmpty(cboFilterRegion.SelectedItem.Text) ||
            String.IsNullOrEmpty(cboFilterSite.SelectedItem.Text))
        {
            Master.ShowSystemFeedback("Please select a Region - Site filter!", "Error");
            bStatus = false;
            return bStatus;
        }
        if (String.IsNullOrEmpty(cboFilterProgram.SelectedItem.Text))
        {
            Master.ShowSystemFeedback("Please select a Program filter!", "Error");
            bStatus = false;
            return bStatus;
        }
        if (chkInpatient.Checked == false && chkOutpatient.Checked == false)
        {
            Master.ShowSystemFeedback("Please select a Clinical Setting filter!", "Error");
            bStatus = false;
            return bStatus;
        }

        if (String.IsNullOrEmpty(strDataFields))
        {
            Master.ShowSystemFeedback("Please select the fields to be included!", "Error");
            bStatus = false;
            return bStatus;
        }

        return bStatus;
    }

    /// <summary>
    /// US: 7987, 7988, 8066, 8067, 7985, 8068. Get the Filters of the "export request" in a string.
    /// </summary>
    /// <returns></returns>
    private string GetFilterString()
    {
        string strFilters = String.Empty;
        DateTime dtFrom = dfFromDate.SelectedDate;
        DateTime dtTo = dfToDate.SelectedDate;

        //filters...
        strFilters = "start_date='" + dtFrom.ToString("yyyyMMdd") + "',";
        strFilters += "end_date='" + dtTo.ToString("yyyyMMdd") + "',";
        strFilters += "region=" + cboFilterRegion.SelectedItem.Value + ",";
        strFilters += "site=" + cboFilterSite.SelectedItem.Value + ",";
        strFilters += "program=" + cboFilterProgram.SelectedItem.Value + ",";
        strFilters += "inpatient=" + (chkInpatient.Checked ? 1 : 0) + ",";
        strFilters += "outpatient=" + (chkOutpatient.Checked ? 1 : 0);

        return strFilters;
    }

    /// <summary>
    /// US: 8081. Cancel In Process "export request". 
    /// </summary>
    /// <param name="lRequestID"></param>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public void OnCancelExportRequest(long lRequestID)
    {
        //Cancel export request...
        CReportsStat rep = null;
        bool bStatus = false;
        
        //cancel...
        rep = new CReportsStat(Master);
        bStatus = rep.CancelExportRequest(lRequestID);
        if (!bStatus)
        {
            if (Master.StatusCode != 0)
            {
                if (Master.StatusCode == 2)
                {
                    Master.ShowSystemFeedback("Request is almost complete and cannot be cancelled.", "Error");
                    LoadMyRequestList();
                }
                else
                {
                    Master.ShowSystemFeedback("Unable to cancel export request.", "Error");
                }
            }

            return;
        }

        //refresh MyReqeuest list
        LoadMyRequestList();

        //show successful msg
        Master.ShowSystemFeedback("Export request canceled!", "Cancel Export Request");

    }

    /// <summary>
    /// US: 8083. Download report.
    /// </summary>
    /// <param name="lRequestID"></param>
    [DirectMethod]
    public void OnDownloadExportRequest(long lRequestID)
    {
        //Download file...
        CReportsStat rep = null;
        DataSet dsFile = null;
        string strReportName = String.Empty;
        string strFileData = string.Empty;

        //download...
        rep = new CReportsStat(Master);
        dsFile = rep.GetExportRequestCSVFileDS(lRequestID);
        if (dsFile == null)
        {
            if (Master.StatusCode != 0)
            {
                Master.ShowSystemFeedback("Unable to download file.", "Error");
            }

            return;
        }

        //get the data from the DataSet
        foreach (DataTable dt in dsFile.Tables)
        {
            foreach (DataRow dr in dt.Rows)
            {
                if (!dr.IsNull("REPORT_NAME"))
                {
                    strReportName = dr["REPORT_NAME"].ToString();
                }
                if (!dr.IsNull("FILE_DATA"))
                {
                    strFileData = dr["FILE_DATA"].ToString();
                }
            }
        }

        //clean file name
        strReportName = strReportName.Replace("<" ,"");
        strReportName = strReportName.Replace(">" ,"");
        strReportName = strReportName.Replace(":" ,"");
        strReportName = strReportName.Replace("\"" ,"");
        strReportName = strReportName.Replace("/" ,"");
        strReportName = strReportName.Replace("\\" ,"");
        strReportName = strReportName.Replace("|" ,"");
        strReportName = strReportName.Replace("?" ,"");
        strReportName = strReportName.Replace("*" ,"");
        
        // build the response...
        this.Response.Clear();
        this.Response.ContentType = "application/octet-stream";
        this.Response.AddHeader("Content-Disposition", "attachment; filename=" + strReportName + "_" + DateTime.Now.ToString("MMddyy") + ".csv");
        
        byte[] byteArray = Encoding.UTF8.GetBytes(strFileData);
        this.Response.OutputStream.Write(byteArray, 0, byteArray.Length);
        
        this.Response.End();

    }

}